<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\StaffType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
use App\Models\Staff;
use App\Models\StaffPosition;
class StaffController extends Controller
{
    protected $layout = 'admin::pages.staff.';
    public function __construct()
    {
        parent::__construct();
        $this->middleware('permission:staff-view', ['only' => ['index']]);
        $this->middleware('permission:staff-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:staff-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-staff-list', 1);
        }
        $data['staff_type'] = StaffType::all();
        $data['data'] = Staff::when(filled(request('keyword')), function ($q) {
            $q->where(function ($q) {
                    $q->where('full_name', 'like', '%' . request('keyword') . '%');
                });
            })
            ->when($this->userBranch, function ($q) {
                $q->whereHas('user', function ($q) {
                    $q->where('branch_id', $this->userBranch->id);
                });
            })
            ->where("status", $req->id)
            ->orderByDesc("id")
            ->paginate(50);

        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data["data"] = Staff::find($req->id);
        $data['staff_type'] = StaffType::where('status',1)->get();
        $data['staff_positions'] = StaffPosition::where('status', 1)->get();
        return view($this->layout.'create', $data);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "staff_type_id" => $req->staff_type_id,
             "staff_position_id" => $req->staff_position_id,
            "full_name" => $req->name,
            "email" => $req->email,
            "phone" => $req->phone,
            "gender" => $req->gender,
            "profile" =>  $req->image ?? $req->tmp_file ?? null,
            "status" => $req->status,
            "cv" => $req->cv ?? $req->cv_file ?? null,
            "noted" => $req->noted,
            "user_id" => auth()->user()->id,
        ];
        $req->validate([
            "email" => "nullable|unique:staffs,email" . ($id ? ",$id" : ''),
            "phone" => "nullable|unique:staffs,email" . ($id ? ",$id" : ""),
            "name"  => "required",
        ], [
            "email.unique" => "Email already exist",
            "phone.unique" => "Phone already exist",
        ]);
        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                Staff::create($item);
            } else {
                Staff::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-staff-list", 1);
        } catch (Exception $error) {
            dd($error);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();

        }
    }
    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Staff::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
