<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Shift;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
class ShiftController extends Controller
{
    protected $layout = 'admin::pages.shift.';
    public function __construct()
    {
        $this->middleware('permission:shift-view', ['only' => ['index']]);
        $this->middleware('permission:shift-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:shift-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-shift-list', 1);
        }
        $data['data'] = Shift::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where("status", $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data["data"] = Shift::where('id',$req->id)->first();
        return view($this->layout.'create', $data);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "name" => $req->name,
            "status" => $req->status,
        ];

        $req->validate([
            "name" => "nullable|unique:class_levels,name" . ($id ? ",$id" : ''),
        ], [
            "name.unique" => "Name already exist",
        ]);
        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                Shift::create($item);
            } else {
                Shift::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-shift-list", 1);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Shift::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
