<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Qoute;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class QouteController extends Controller
{
    protected $layout = 'admin::pages.qoute.';
    function __construct()
    {
        $this->middleware('permission:qoute-view', ['only' => ['index']]);
        $this->middleware('permission:qoute-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:qoute-update', ['only' => ['onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-qoute-list', 1);
        }
        $data['data'] = Qoute::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
                $q->orWhere('description', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        if ($req->id) {
            $data['data'] = Qoute::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create');
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name' => 'required',
            ],
            [
                'name.required' => 'field is require',
            ]
        );
        $items = [
            'name' => $req->name,
            'description' => $req->description,
            'image' => $req->image ?? $req->tmp_file ?? null,
            'status' => $req->status ?? 1,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Qoute::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Qoute::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-qoute-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Qoute::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}