<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
use App\Models\LessonOccupation;
class OccupationController extends Controller
{
    protected $layout = 'admin::pages.occupation.';
    public function __construct()
    {
        $this->middleware('permission:lesson-occupation-view', ['only' => ['index']]);
        $this->middleware('permission:lesson-occupation-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:lesson-occupation-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-occupation-list', 1);
        }
        $data['data'] = LessonOccupation::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where("status", $req->id)
            ->orderByDesc("id")
            ->paginate(50);

        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        if($req->id){
            $data["data"] = LessonOccupation::findOrFail($req->id);
            return view($this->layout.'create', $data);
        }
        return view($this->layout.'create');
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "name" => $req->name,
            "status" => $req->status,
        ];

        $req->validate([
            "name" => "nullable|unique:lesson_occupations,name" . ($id ? ",$id" : ''),
        ], [
            "name.unique" => "Name already exist",
        ]);
        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                LessonOccupation::create($item);
            } else {
                LessonOccupation::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-occupation-list", 1);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            LessonOccupation::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
