<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\UploadFile;
use Illuminate\Http\Request;
use App\Models\Lesson;
use App\Models\LessonDocument;
use App\Models\LessonOccupation;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;

class LessonController extends Controller
{
    //
    protected $layout = 'admin::pages.lesson.';
    public function __construct()
    {
        parent::__construct();
        $this->middleware('permission:lesson-view', ['only' => ['index']]);
        $this->middleware('permission:lesson-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:lesson-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-lesson-list', 1);
        }
        $data['data'] = Lesson::with('occupation')
            ->when(filled(request('keyword')), function ($q) {
                $q->where(function ($q) {
                    $q->where('name', 'like', '%' . request('keyword') . '%');
                });
            })
            ->when($this->userBranch, function ($q) {
                $q->whereHas('user', function ($q) {
                    $q->where('branch_id', $this->userBranch->id);
                });
            })
            ->whereHas('occupation', function ($q) {
                $q->where('status', 1);
            })
            ->where('status', $req->id)
            ->orderByDesc('id')
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }

    public function onCreate(Request $req)
    {
        $data['data'] = Lesson::with('documents')->find($req->id);
        $data['occupation'] = LessonOccupation::where('status', 1)->get();
        return view($this->layout . 'create', $data);
    }

    public function onSave(Request $req)
    {
        try { 
            DB::beginTransaction(); 
            $id = $req->id;
            $item = [
                'lesson_occupation_id' => $req->lesson_occupation_id,
                'competency_type' => $req->competency_type,
                'name' => $req->name,
                'short_name' => $req->short_name,
                'practice_hour' => $req->practice_hour,
                'practice_duration_type' => $req->practice_duration_type,
                'theory_hour' => $req->theory_hour,
                'theory_duration_type' => $req->theory_duration_type,
                'status' => $req->status,
                'video' => $req->video,
                'document' => null,
                'user_id' => auth()->user()->id,
            ];
            $req->validate(
                [
                    'name' => 'unique:lessons,name' . ($id ? ",$id" : ''),
                ],
                [
                    'name.unique' => 'Name already exist',
                ],
            ); 
            $status = 'Create success.';
            if (!$id) {
                $data = Lesson::create($item);
                if (isset($req->documents) && count($req->documents) > 0) {
                    foreach ($req->documents as $doc) {
                        LessonDocument::create([
                            'lesson_id' => $data->id,
                            'source' => $doc,
                        ]);
                    }
                }
            } else {
                $data = Lesson::find($id);
                $data->update($item);
                if (count($data->documents) > 0) {
                    foreach ($data->documents as $doc) {
                        $doc->delete();
                    }
                }
                if (isset($req->documents) && count($req->documents) > 0) {
                    foreach ($req->documents as $doc) {
                        LessonDocument::create([
                            'lesson_id' => $data->id,
                            'source' => $doc,
                        ]);
                    }
                }
                $status = 'Update success.';
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-lesson-list', 1);
        } catch (Exception $error) {
            DB::rollback();
            dd($error);
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            'status' => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? 'Disable successful!' : 'Enable successful!';
            Lesson::where('id', $req->id)->update($item);
            DB::commit();
            Session::flash('success', $status);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}