<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InternshipPlace;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
class InternshipPlaceController extends Controller
{
    protected $layout = 'admin::pages.internshipPlace.';
   public function __construct()
    {
        parent::__construct();
        $this->middleware('permission:internship-place-view', ['only' => ['index']]);
        $this->middleware('permission:internship-place-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:internship-place-update', ['only' => ['onCreate', 'onSave']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-internship-place-list', 1);
        }
        $data['data'] = InternshipPlace::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                    $q->where('place_name', 'like', '%' . request('search') . '%');
                });
            })
            ->when($this->userBranch, function ($q) {
                $q->whereHas('user', function ($q) {
                    $q->where('branch_id', $this->userBranch->id);
                });
            })
            ->orderByDesc("id")
            ->paginate(50);

        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        if($req->id){
            $data["data"] = InternshipPlace::findOrFail($req->id);
            return view($this->layout.'create', $data);
        }
        return view($this->layout.'create');
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "place_name" => $req->place_name,
            "contact_number" => $req->contact_number,
            "location" => $req->location,
            "user_id" => auth()->user()->id,
        ];

        $req->validate([
            "contact_number" => "required|unique:internship_places,contact_number" . ($id ? ",$id" : ''),
        ], [
            "contact_number.unique" => "Phone already exist",
        ]);
        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                InternshipPlace::create($item);
            } else {
                InternshipPlace::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-internship-place-list", 1);
        } catch (Exception $error) {
          //  return $error;
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
}
