<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Album;
use Illuminate\Http\Request;
use App\Models\Gallery;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class GalleryController extends Controller
{
    protected $layout = 'admin::pages.gallery.';
    function __construct()
    {
        $this->middleware('permission:gallery-view', ['only' => ['index']]);
        $this->middleware('permission:gallery-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:gallery-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-gallery-list', 1);
        }
        $data['data'] = Gallery::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data['albums'] = Album::where(['album_type' => 'Image', 'status' => 1])->get();
        if ($req->id) {
            $data['data'] = Gallery::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create', $data);
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name' => 'required',
                'image' => 'required',
                'album_id' => 'required',
            ],
            [
                'name.required' => 'field is require',
                'image.required' => 'field is require',
                'album_id.required' => 'field is require',
            ]
        );
        $items = [
            'name' => $req->name,
            'image' => $req->image ?? $req->tmp_file ?? null,
            'description' => $req->description,
            'album_id' => $req->album_id,
            'status' => $req->status ?? 1,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Gallery::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Gallery::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-gallery-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Gallery::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
