<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Classes;
use App\Models\Lesson;
use App\Models\ExamControl;
use App\Models\ExamSubject;
use App\Models\ExamType;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class ExamSubjectController extends Controller
{
     public function __construct()
    {
        $this->middleware('permission:exam-subject-view', ['only' => ['index']]);
        $this->middleware('permission:exam-subject-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:exam-subject-destroy', ['only' => ['onDelete']]);
        $this->middleware('permission:exam-subject-view-info', ['only' => ['onView']]);
    }
    public function index()
    {
        $data = ExamSubject::where('class_id', request('class_id'))->where('exam_id', request('exam_id'))->with('staff')->get();
        return response()->json($data);
    }
    public function onView()
    {
        $data = ExamSubject::findOrFail(request('id'));
        return response()->json($data);
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            'class_id' => $req->class_id,
            'exam_id' => $req->exam_id,
            'sheet_issuer_id' => $req->sheet_issuer_id,
            'description' => $req->description,
            'google_doc_url' => $req->google_doc_url,
        ];
        $req->validate([
            "class_id" => 'required',
            "exam_id" => 'required',
            "sheet_issuer_id"  => "required",
            "description" => 'required',
        ]);
        DB::beginTransaction();
        try {
            if (!$id) {
                ExamSubject::create($item);
                $status = 'Created success';
            } else {
                ExamSubject::find($id)->update($item);
                $status = 'Updated success';
            }
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => $status,
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            dd($e);
            return response()->json([
                'code' => 40005,
                'message' => 'Created unsuccess!',
            ]);
        }
    }
    public function onDelete()
    {
        $data = ExamSubject::findOrFail(request('id'));
        DB::beginTransaction();
        try {
            $data->delete();
            if ($data->exam_answer_sheets && count($data->exam_answer_sheets) > 0) {
                foreach ($data->exam_answer_sheets as $eas) {
                    $eas->delete();
                }
            }
            DB::commit();
            Session::flash('success', 'Delete success.');
            return response()->json([
                'code' => 20000,
                'message' => 'Deleted success.',
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('warning', 'Deleted unsuccess!');
            return response()->json([
                'code' => 40005,
                'message' => 'Deleted unsuccess',
            ]);
        }
    }
}
