<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ExamScore;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class ExamScoreController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:exam-score-create', ['only' => ['onCreate', 'onSave']]);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        DB::beginTransaction();

        try {
            for ($i = 0; $i < count($req->lesson_id); $i++) {
                $score = 0;
                if ($req->lesson_score[$i] > 100) {
                    $score = 100;
                } elseif ($req->lesson_score[$i] < 0) {
                    $score = 0;
                } else {
                    $score = $req->lesson_score[$i];
                }
                ExamScore::updateOrCreate(
                    [
                        'class_id' => $req->class_id,
                        'student_id' => $req->student_id,
                        'lesson_id' => $req->lesson_id[$i],
                    ],
                    [
                        'class_id' => $req->class_id,
                        'student_id' => $req->student_id,
                        'lesson_id' => $req->lesson_id[$i],
                        'score' => $score ?? 0,
                    ]
                );
                $score = 0;
            }
            (new StudentScoreController)->setIsScorePass($req->class_id, $req->student_id);
            DB::commit();
            Session::flash('success', 'Create Success.');
            return redirect()->back();
        } catch (\Exception $e) {
            Session::flash('warning', 'Create Unsuccess!');
            return redirect()->back();
        }
    }
}
