<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use App\Models\ExamAnswerSheet;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class ExamAnswerSheetController extends Controller
{
    public function index()
    {
        $data = ExamAnswerSheet::where('class_id', request('class_id'))
            ->with('exam_subject', function ($q) {
                $q->with('staff');
                $q->with('exam_control', function ($qq) {
                    $qq->with('exam_type');
                });
            })
            ->with('exam_candidate', function ($q) {
                $q->with('student');
            })
            ->get();
        return response()->json($data);
    }

    public function onExamSubject()
    {
        $data = ExamAnswerSheet::where('class_id', request('class_id'))->where('exam_subject_id', request('exam_subject_id'))->with('exam_candidate', function ($q) {
            $q->with('student');
        })
            ->with('exam_subject')
            ->get();

        return response()->json($data);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;

        $acquired_score = 0;
        if ($req->acquired_score > 100) {
            $acquired_score = 100;
        } elseif ($req->acquired_score < 0) {
            $acquired_score = 0;
        } else {
            $acquired_score = $req->acquired_score;
        }
        $item = [
            'class_id' => $req->class_id,
            'exam_subject_id' => $req->exam_subject_id,
            'exam_candidate_id' => $req->exam_candidate_id,
            'acquired_score' => $acquired_score,
            'answer_sheet' => $req->answer_sheet,
        ];
        $vali = Validator::make(
            $req->all(),
            [
                'class_id' => 'required',
                'exam_subject_id' => 'required',
                'exam_candidate_id' => 'required',
                'acquired_score' => 'required|min:0|max:100',
            ],
            [
                'class_id.required' => 'Field is Required',
                'exam_subject_id.required' => 'Field is Required',
                'exam_candidate_id.required' => 'Field is Required',
                'acquired_score.required' => 'Field is Required',
            ]
        );
        DB::beginTransaction();
        try {
            if (!$id) {
                ExamAnswerSheet::updateOrCreate(
                    [
                        'class_id' => $req->class_id,
                        'exam_subject_id' => $req->exam_subject_id,
                        'exam_candidate_id' => $req->exam_candidate_id,
                    ],
                    $item
                );
                $status = 'Created success';
            } else {
                ExamAnswerSheet::find($id)->update($item);
                $status = 'Updated success';
            }
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => $status,
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Created unsuccess!',
                'validation' => $vali->errors(),
            ]);
        }
    }
    public function onDelete()
    {
        $data = ExamAnswerSheet::findOrFail(request('id'));
        DB::beginTransaction();
        try {
            $data->delete();
            if ($data->student_lesson_score && $data->student_lesson_score != null) {
                $data->student_lesson_score->delete();
            }
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => 'Deleted success.',
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Deleted unsuccess',
            ]);
        }
    }
}
