<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\Slide;
use App\Models\Trainer;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class CourseController extends Controller
{
    protected $layout = 'admin::pages.course.';
    function __construct()
    {
        $this->middleware('permission:course-view', ['only' => ['index']]);
        $this->middleware('permission:course-create', ['only' => ['onSave', 'onCreate']]);
        $this->middleware('permission:course-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-course-list', 1);
        }
        $data['data'] = Course::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->when(request('popular'), function($q){
                $q->where(function($q){
                    if(request('popular') == 'popular'){
                        $q->where('popular', 1); 
                    }
                    if(request('popular') == 'normal'){
                        $q->where('popular', 0); 
                    }
                });
            })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data['trainers'] = Trainer::where('status', 1)->get();
        // return $data;
        if ($req->id) {
            $data['data'] = Course::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create', $data);
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name'     => 'required',
                'date'     => 'required',
                'duration' => 'required',
            ],
            [
                'name.required'     => 'field is require',
                'date.required'     => 'field is require',
                'duration.required' => 'field is require',
            ]
        );
        $items = [
            'name'           => $req->name,
            'image'          => $req->image ?? $req->tmp_file ?? null,
            'fee'            => $req->fee ?? 'Free',
            'contact_number' => $req->contact_number,
            'date'           => $req->date,
            'duration'       => $req->duration,
            'description'    => $req->description,
            'trainer_id'     => $req->trainer_id,
            'status'         => $req->status ?? 1, 
            'popular'        => $req->popular ? 1 : 0,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Course::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Course::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-course-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Course::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }

    public function slide(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-slide-list', 1);
        }
        $data['data'] = Slide::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->where('type', 'course')
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'slide.index', $data);
    }

    public function onCreateSlide(Request $req)
    {
        if ($req->id) {
            $data['data'] = Slide::where(['id' => $req->id, 'type' => 'course'])->first();
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'slide.create');
        }
    }
}
