<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
use App\Models\ClassStatus;
class ClassStatusController extends Controller
{
    protected $layout = 'admin::pages.classStatus.';
    public function __construct()
    {
        $this->middleware('permission:class-status-view', ['only' => ['index']]);
        $this->middleware('permission:class-status-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:class-status-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-class-status-list', 1);
        }
        $data['data'] = ClassStatus::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where("status", $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        if($req->id){
            $data["data"] = ClassStatus::findOrFail($req->id);
            return view($this->layout.'create', $data);
        }
        return view($this->layout.'create');
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "name" => $req->name,
            "status" => $req->status,
        ];

        $req->validate([
            "name" => "nullable|unique:class_statuses,name" . ($id ? ",$id" : ''),
        ], [
            "name.unique" => "Name already exist",
        ]);
        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                ClassStatus::create($item);
            } else {
                ClassStatus::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-class-status-list", 1);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            ClassStatus::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
