<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use App\Models\Classes;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use App\Models\ClassImage;
use Carbon\Carbon;


class ClassImageController extends Controller
{
    protected $layout = 'admin::pages.class.classImage.';
    public function __construct()
    {
        $this->middleware('permission:class-image-view', ['only' => ['index']]);
        $this->middleware('permission:class-image-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:class-image-destroy', ['only' => ['onDelete']]);
    }
    public function index()
    {
        $data['data'] = ClassImage::where('class_id', request('class_id'))->get()->sortByDESC('image_date');
        return view($this->layout . 'index', $data);
    }

    public function onCreate()
    {
        $classes = Classes::findOrFail(request('class_id'));
        if (!$classes) {
            Session::flash('danger', 'Invalided valued');
            return redirect()->back();
        }
        return view($this->layout . 'create');
    }

    public function onSave(Request $req)
    {
        $classes = Classes::findOrFail($req->class_id);
        $class_id = '';
        if ($classes) {
            $class_id = $classes->id;
        } else {
            Session::flash('danger', 'Invalided valued');
            return redirect()->back();
        }

        $item = [
            "class_id" => $class_id,
            "image_date" => (new Carbon($req->image_date))->format('Y-m-d H:i:s'),
            "image_description" => $req->description,
            "image" =>  $req->image ?? $req->tmp_file,
        ];
        $req->validate([
            'image_date' => 'required',
            'image' => 'required',
        ]);

        DB::beginTransaction();
        try {
            ClassImage::create($item);
            DB::commit();
            Session::flash('success', 'Uploaded success');
            return redirect()->route('admin-class-image-list', $class_id);
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('warning', 'Uploaded unsuccess!');
            return redirect()->back();
        }
    }

    public function onDelete(Request $req)
    {
        $data = ClassImage::findOrFail($req->id);
        DB::beginTransaction();
        try {
            $image_path = public_path('file_manager' . $data->image);
            File::delete($image_path);
            $data->delete();
            DB::commit();
            Session::flash('success', 'Deleted success');
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            Session::flash('warning', 'Deleted unsuccess!');
            return redirect()->back();
        }
    }
}
