<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        try {
            
            $request->validate([
                'email' => 'required',
                'password' => 'required',
            ]);
            if (Auth::attempt(['email' => $request->email, 'password' => $request->password, 'status' => 1], $request->remember)) {
                Session::flash('status', true);
                if (Auth::user()->role == $this->isRoleTeacher) {
                   // return request()->returnUrl ? redirect()->to(request()->returnUrl) : redirect()->route('admin-student-list');
                    return redirect()->route('admin-teacher-portal-list');
                }
                return request()->returnUrl ? redirect()->to(request()->returnUrl) : redirect()->route('admin-student-list');
            } else {
                return Redirect::back()->with('status', false);
            }
        } catch (\Throwable $th) {
            //throw $th;

            Log::error("Error : AuthController > Login | Message : " . $th->message);
        }
    }

    public function signOut()
    {
        Auth::logout();
        session()->forget('current_admin_login');
        return redirect()->route('admin-login');
    }
}
