<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\Cover;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    protected $layout = 'admin::pages.about.';
    function __construct()
    {
        $this->middleware('permission:about-view', ['only' => ['onCreate', 'onSave', 'onSaveCover']]);
    }
    public function onCreate()
    {
        $data['data'] = About::where('status', 1)->first();
        return view($this->layout . 'create', $data);
    }
    public function onSave(Request $req)
    {
        // $data = About::first();
        $req->validate(
            [
                'title' => 'required',
                'description' => 'required',
                'mission' => 'required',
                'vision' => 'required',
            ],
            [
                'title.required' => 'field is require',
                'description.required' => 'field is require',
                'mission.required' => 'field is require',
                'vision.required' => 'field is require',
            ]
        );
        $items = [
            'title' => $req->title,
            'description' => $req->description,
            'mission' => $req->mission,
            'vision' => $req->vision,
            'image' => $req->image ?? $req->tmp_file ?? null,
            'status' => 1,
        ];
        DB::beginTransaction();
        try {
            About::updateOrCreate(
                [
                    'status' => 1
                ],
                $items
            );
            $status = "Update success.";
            DB::commit();
            Session::flash('success', $status);
            return redirect()->back();
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onCreateCover()
    {
        $data['data'] = Cover::where('type', 'about')->first();
        return view($this->layout . 'cover', $data);
    }
}
