<?php

function format_number($number)
{

    $number = (0 + str_replace(",", "", $number));
    if (!is_numeric($number)) {
        return false;
    }

    if ($number > 1000000000000) {
        return round(($number / 1000000000000), 2) . 'T';
    } else if ($number > 1000000000) {
        return round(($number / 1000000000), 2) . 'B';
    } else if ($number > 1000000) {
        return round(($number / 1000000), 2) . 'M';
    } else if ($number > 1000) {
        return round(($number / 1000), 2) . 'K';
    }
    return number_format($number);
}

function getMapEmbedSrc($embedMap)
{
    preg_match('~iframe.*src="([^"]*)"~', $embedMap, $result);
    if (!isset($embedMap) || count($result) <= 0) {
        return 'https://www.google.com/maps/embed?pb=';
    }
    return $result[1];
}


if (!function_exists('videoUrl')) {
    function videoUrl($url) {
        // if url is match with youtube url pattern and return video id
        $regExp = '/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/';

        // if url is match with youtube embed iframe pattern and return video id
        $regYoutubeEmbed = '/<iframe.*?src="(.*?)"[^>]*><\/iframe>/';

        // var match = url.match(regExp);
        $match = preg_match($regExp, $url, $matches);
        $result = '';

        if ($match && strlen($matches[2]) == 11) {
            $result = $matches[2];
        } else if (preg_match($regYoutubeEmbed, $url, $matches)) {
            $result = $matches[1];
        } else {
            $result = $url;
        }

        return $result;
    }
}

if (!function_exists('previewVideo')) {
    function previewVideo($url) {
        $result = videoUrl($url);

        // if result is not youtube video id and iframe url is not match with youtube url pattern
        if (strlen($result) != 11 && !preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/', $result)) {
            return 'https://www.facebook.com/plugins/video.php?height=315&href=' . $result . '&show_text=false&width=560&t=0';
        }

        // if iframe url is match with youtube url pattern
        if (preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/', $result)) {
            return $result;
        }

        return 'https://www.youtube.com/embed/' . $result;
    }
}