<?php

namespace App\Exports;

use App\Models\Student;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Sheet;
use Maatwebsite\Excel\Concerns\WithDrawings;

\PhpOffice\PhpSpreadsheet\Cell\Cell::setValueBinder(new \PhpOffice\PhpSpreadsheet\Cell\AdvancedValueBinder());
Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
    $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
});

class StudentsExport implements FromView, WithEvents, WithDrawings
{
    private $data; 

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function view(): View
    {
        return view('admin::pages.student.excel', [
            'data' => $this->data,
        ]);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->styleCells("A:P", [
                    'font' => array(
                        'name' => 'Hanuman',
                        'size' => "11",
                    ),
                    'alignment' => [ 
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    ],
                ]);
                $event->sheet->styleCells("A7:P7", [
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => ['rgb' => 'D0D0D0'],
                    ],
                    'font' => array(
                        'bold' => true,
                    ),
                ]);
                $event->sheet->getDelegate()->mergeCells('B3:C5');
                $event->sheet->getDelegate()->mergeCells('E3:I5');
                $event->sheet->setCellValue('E3', 'LICE Student List');
                $event->sheet->styleCells("E3:I5", [
                    'font' => array(
                        'name' => 'Moul',
                        'size' => "36",
                    ),
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    ],
                ]);

                $columns = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'];
                $workSheet = $event->sheet->getDelegate();
                $workSheet->getSheetView()->setZoomScale(90);
                //print fit column
                $workSheet->getPageSetup()->setFitToWidth(1);
                $workSheet->getPageSetup()->setFitToHeight(0);
                //set width column
                for ($i = 0; $i < count($columns); $i++) {
                    if ($i == 0) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(10); #no
                    } elseif ($i == 1) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(15); #sid
                    } elseif ($i == 2) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(20); #name_latin
                    } elseif ($i == 3) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(20); #name_khmer
                    } elseif ($i == 4) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(10); #gender
                    } elseif ($i == 5) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(20); #dob
                    } elseif ($i == 6) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(20); #id_card
                    } elseif ($i == 7) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(15); #phone_number
                    } elseif ($i == 8) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(15); #telegram
                    } elseif ($i == 9) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(20); #email
                    } elseif ($i == 10) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(20); #education
                    } else if($i > 10 && $i < (count($columns) - 1)) {
                        $workSheet->getColumnDimension($columns[$i])->setWidth(30); #address
                    }else{
                        $workSheet->getColumnDimension($columns[$i])->setWidth(10); #status
                    }
                } 
                for ($i = 0; $i < count($this->data) + 100; $i++) {
                    $workSheet->getRowDimension($i)->setRowHeight(25);
                }
            }
        ];
    }
    public function drawings()
    {
        $default_logo = "images/logo/LICE_serge_comtesse_cambodia_black.png";
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath(public_path($default_logo));
        $drawing->setCoordinates('B3');
        $drawing->setHeight(90);
        $drawing->setOffsetX(121);
        $drawing->setOffsetY(3);

        return $drawing;
    }
}

